% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fig.R
\name{Fig}
\alias{Fig}
\title{Fig for Your Config}
\description{
\code{Fig} class is a main driver of this package. For usage details
refer to \code{Fig} class methods documentation.

Fig provides a set of exported functions. This makes \code{Fig} class instance
creation optional, and makes the package itself mimic being a class instance.
Those functions are wrappers on an internal \code{Fig} object.
}
\examples{

## ------------------------------------------------
## Method `Fig$new`
## ------------------------------------------------

fig <- Fig$new()
fig <- Fig$new(env_prefix = "RCONNECT_")

## ------------------------------------------------
## Method `Fig$configure`
## ------------------------------------------------

fig <- Fig$new(env_prefix = "RCONNECT_")
fig$configure(env_prefix = "foo_")
fig$configure(split_on = "")
fig$configure() # has no effect

## ------------------------------------------------
## Method `Fig$delete`
## ------------------------------------------------

fig <- Fig$new()
fig$store_many("foo" = 1, "bar" = 2, "baz" = 3)
fig$delete("foo")
fig$delete("bar", "baz")
fig$get_many("foo", "bar", "baz") # == list(NULL, NULL, NULL)

## ------------------------------------------------
## Method `Fig$delete_all`
## ------------------------------------------------

fig <- Fig$new()
fig$store_many("foo" = 1, "bar" = 2, "baz" = 3)
fig$delete_all()
fig$get_many("foo", "bar", "baz") # == list(NULL, NULL, NULL)

## ------------------------------------------------
## Method `Fig$get`
## ------------------------------------------------

fig <- Fig$new()
fig$store("foo", 1)
fig$get("foo")

fig$store("bar", list(baz = 2))
fig$get("bar.baz")

fig$configure(split_on = "")
fig$get("bar.baz") # == NULL

## ------------------------------------------------
## Method `Fig$get_many`
## ------------------------------------------------

fig <- Fig$new()
fig$store_many(foo =  1, bar = 2, baz = 3)
fig$get_many("foo", "bar")

## ------------------------------------------------
## Method `Fig$get_all`
## ------------------------------------------------

fig <- Fig$new()
fig$store_many(foo =  1, bar = 2, baz = 3)
fig$get_all()

## ------------------------------------------------
## Method `Fig$store`
## ------------------------------------------------

fig <- Fig$new()
fig$store("foo", 1)
fig$store("bar", 123)$store("baz", list(1, 2, 3))
fig$store("x.y", "a")

## ------------------------------------------------
## Method `Fig$store_list`
## ------------------------------------------------

fig <- Fig$new()
fig$store_list(list(foo = 123, bar = "abc"))

## ------------------------------------------------
## Method `Fig$store_many`
## ------------------------------------------------

fig <- Fig$new()
fig$store_many("foo" = 1, "bar" = 2)
fig$store_many("foo.bar.baz" = 1)
fig$store_many("foo" = "a", "baz" = 123)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Fig$new()}}
\item \href{#method-configure}{\code{Fig$configure()}}
\item \href{#method-delete}{\code{Fig$delete()}}
\item \href{#method-delete_all}{\code{Fig$delete_all()}}
\item \href{#method-get}{\code{Fig$get()}}
\item \href{#method-get_many}{\code{Fig$get_many()}}
\item \href{#method-get_all}{\code{Fig$get_all()}}
\item \href{#method-store}{\code{Fig$store()}}
\item \href{#method-store_list}{\code{Fig$store_list()}}
\item \href{#method-store_many}{\code{Fig$store_many()}}
\item \href{#method-clone}{\code{Fig$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a New Fig Instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$new(env_prefix = "", split_on = ".")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{env_prefix}}{(character) A prefix to be prepended to a key before
system environment lookup.}

\item{\code{split_on}}{(character) A value to split keys on. See Details
section. Providing an empty string disables this behavior.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Fig treats character provided in \code{split_on} as key nest level
delimiter. Therefore, \code{split_on} set to \code{"."} (default value)
\code{fig$get("foo.bar")} is equivalent to \code{fig$get("foo")$bar}. Similarly
fig$set("foo.bar", 1) is equivalent to \code{fig$set("foo", list(bar = 1))}.
This behavior can be disabled either by passing an empty string either to
\code{new()} during \code{Fig} instance creation or to \code{configure()} function to
modify an existing instance.
}

\subsection{Returns}{
New instance of \code{Fig}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fig <- Fig$new()
fig <- Fig$new(env_prefix = "RCONNECT_")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-configure"></a>}}
\if{latex}{\out{\hypertarget{method-configure}{}}}
\subsection{Method \code{configure()}}{
Configure a Fig Instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$configure(env_prefix, split_on)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{env_prefix}}{(character) A prefix to be prepended to a key before
system environment lookup. Pass an empty string to reset.}

\item{\code{split_on}}{(character) A value to split keys on. See Details
section in \code{new()}. Providing an empty string disables this behavior.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Unset arguments do not change configuration.
}

\subsection{Returns}{
Reference to self. Other methods can be chained after this one.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fig <- Fig$new(env_prefix = "RCONNECT_")
fig$configure(env_prefix = "foo_")
fig$configure(split_on = "")
fig$configure() # has no effect
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
Delete Stored Values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$delete(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Keys to be deleted.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Reference to self. Other methods can be chained after this one.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fig <- Fig$new()
fig$store_many("foo" = 1, "bar" = 2, "baz" = 3)
fig$delete("foo")
fig$delete("bar", "baz")
fig$get_many("foo", "bar", "baz") # == list(NULL, NULL, NULL)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete_all"></a>}}
\if{latex}{\out{\hypertarget{method-delete_all}{}}}
\subsection{Method \code{delete_all()}}{
Delete All Stored Values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$delete_all()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Reference to self. Other methods can be chained after this one.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fig <- Fig$new()
fig$store_many("foo" = 1, "bar" = 2, "baz" = 3)
fig$delete_all()
fig$get_many("foo", "bar", "baz") # == list(NULL, NULL, NULL)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
Retrieve a Stored Value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$get(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{A key to retrieve a value for.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function returns values based on a following priority
(highest to lowest). If value is not found, then it looks up next level
in the precedence.
\enumerate{
\item System environment variable (case sensitive)
\item Value manually set
}

For system environment lookup dots are replaced by underscores, e.g.
\code{fig$get("foo.bar")} will look up \strong{foo_bar}.
}

\subsection{Returns}{
A value associated with provided \code{key}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fig <- Fig$new()
fig$store("foo", 1)
fig$get("foo")

fig$store("bar", list(baz = 2))
fig$get("bar.baz")

fig$configure(split_on = "")
fig$get("bar.baz") # == NULL
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_many"></a>}}
\if{latex}{\out{\hypertarget{method-get_many}{}}}
\subsection{Method \code{get_many()}}{
Retrieve Any Number of Stored Values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$get_many(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Keys to retrieve values for.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See \code{get()} Details section.
}

\subsection{Returns}{
An unnamed list of values associated with keys provided in \code{...}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fig <- Fig$new()
fig$store_many(foo =  1, bar = 2, baz = 3)
fig$get_many("foo", "bar")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_all"></a>}}
\if{latex}{\out{\hypertarget{method-get_all}{}}}
\subsection{Method \code{get_all()}}{
Retrieve All Stored Values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$get_all()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See \code{get()} Details section.
}

\subsection{Returns}{
An unnamed list of all stored values.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fig <- Fig$new()
fig$store_many(foo =  1, bar = 2, baz = 3)
fig$get_all()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-store"></a>}}
\if{latex}{\out{\hypertarget{method-store}{}}}
\subsection{Method \code{store()}}{
Store a Value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$store(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{A key to store a value for.}

\item{\code{value}}{A value to be stored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Reference to self. Other methods can be chained after this one.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fig <- Fig$new()
fig$store("foo", 1)
fig$store("bar", 123)$store("baz", list(1, 2, 3))
fig$store("x.y", "a")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-store_list"></a>}}
\if{latex}{\out{\hypertarget{method-store_list}{}}}
\subsection{Method \code{store_list()}}{
Store a List's Contents
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$store_list(l)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{l}}{(named list) Names are used as keys for storing their values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Reference to self. Other methods can be chained after this one.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fig <- Fig$new()
fig$store_list(list(foo = 123, bar = "abc"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-store_many"></a>}}
\if{latex}{\out{\hypertarget{method-store_many}{}}}
\subsection{Method \code{store_many()}}{
Set Any Number of Values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$store_many(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Named arguments. Names are used as keys for storing argument
values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Reference to self. Other methods can be chained after this one.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fig <- Fig$new()
fig$store_many("foo" = 1, "bar" = 2)
fig$store_many("foo.bar.baz" = 1)
fig$store_many("foo" = "a", "baz" = 123)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fig$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
