% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fake_request.R
\name{fake_request}
\alias{fake_request}
\title{Create a fake request to use in testing}
\usage{
fake_request(
  url,
  method = "get",
  app_location = "",
  content = "",
  headers = list(),
  ...,
  remote_address = "123.123.123.123"
)
}
\arguments{
\item{url}{A complete url for the resource the request should ask for}

\item{method}{The request type (get, post, put, etc). Defaults to \code{"get"}}

\item{app_location}{A string giving the first part of the url path that should
be stripped from the path}

\item{content}{The content of the request, either a raw vector or a string}

\item{headers}{A list of name-value pairs that defines the request headers}

\item{...}{Additional name-value pairs that should be added to the request}

\item{remote_address}{The IP address of the presumed sender}
}
\value{
A Rook-compliant environment
}
\description{
This function creates a new request for a specific resource defined by a
URL. It mimics the format of the requests provided through httpuv, meaning
that it can be used in place for the requests send to the \code{before-request},
\code{request}, and \code{after-request} handlers. This is only provided so that
handlers can be tested without having to start up a server.
}
\examples{
req <- fake_request(
    'http://www.my-fake-website.com/path/to/a/query/?key=value&key2=value2',
    content = 'Some important content'
)

# Get the main address of the URL
req[['SERVER_NAME']]

# Get the query string
req[['QUERY_STRING']]

# ... etc.

# Cleaning up connections
rm(req)
gc()

}
\keyword{internal}
