% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_orthus.R
\name{orthus_fit}
\alias{orthus_fit}
\alias{orthus}
\title{Interface to fit orthus models}
\usage{
orthus(
  Y = NULL,
  Z = NULL,
  X = NULL,
  upsilon = NULL,
  Theta = NULL,
  Gamma = NULL,
  Xi = NULL,
  init = NULL,
  pars = c("Eta", "Lambda", "Sigma"),
  ...
)
}
\arguments{
\item{Y}{D x N matrix of counts (if NULL uses priors only)}

\item{Z}{P x N matrix of counts (if NULL uses priors only - must be present/absent
if Y is present/absent)}

\item{X}{Q x N matrix of covariates (design matrix) (if NULL uses priors only, must
be present to sample Eta)}

\item{upsilon}{dof for inverse wishart prior (numeric must be > D)
(default: D+3)}

\item{Theta}{(D-1+P) x Q matrix of prior mean for regression parameters
(default: matrix(0, D-1+P, Q))}

\item{Gamma}{QxQ prior covariance matrix
(default: diag(Q))}

\item{Xi}{(D-1+P)x(D-1+P) prior covariance matrix
(default: ALR transform of diag(1)*(upsilon-D)/2 - this is
essentially iid on "base scale" using Aitchison terminology)}

\item{init}{(D-1) x Q initialization for Eta for optimization}

\item{pars}{character vector of posterior parameters to return}

\item{...}{arguments passed to \code{\link{optimPibbleCollapsed}} and
\code{\link{uncollapsePibble}}}
}
\value{
an object of class pibblefit
}
\description{
This function is largely a more user friendly wrapper around
\code{\link{optimPibbleCollapsed}} and
\code{\link{uncollapsePibble}} for fitting orthus models.
See details for model specification.
Notation: \code{N} is number of samples, \code{P} is the number of dimensions
of observations in the second dataset,
\code{D} is number of multinomial categories, \code{Q} is number
of covariates, \code{iter} is the number of samples of \code{eta} (e.g.,
the parameter \code{n_samples} in the function
\code{\link{optimPibbleCollapsed}})
}
\details{
the full model is given by:
\deqn{Y_j \sim Multinomial(\pi_j)}{Y_j \sim Multinomial(Pi_j)}
\deqn{\pi_j = \Phi^{-1}(\eta_j)}{Pi_j = Phi^(-1)(Eta_j)}
\deqn{cbind(\eta, Z) \sim MN_{D-1+P \times N}(\Lambda X, \Sigma, I_N)}{cbind(Eta, Z) \sim MN_{D-1+P x N}(Lambda*X, Sigma, I_N)}
\deqn{\Lambda \sim MN_{D-1+P \times Q}(\Theta, \Sigma, \Gamma)}{Lambda \sim MN_{D-1+P x Q}(Theta, Sigma, Gamma)}
\deqn{\Sigma \sim InvWish(\upsilon, \Xi)}{Sigma \sim InvWish(upsilon, Xi)}
Where \eqn{\Gamma}{Gamma} is a Q x Q covariance matrix, and \eqn{\Phi^{-1}}{Phi^(-1)} is
ALRInv_D transform.
That is, the orthus model models the latent multinomial log-ratios (Eta) and
the observations of the second dataset jointly as a linear model. This allows
Sigma to also describe the covariation between the two datasets.

Default behavior is to use MAP estimate for uncollaping the LTP
model if laplace approximation is not preformed.
}
\examples{
sim <- orthus_sim()
fit <- orthus(sim$Y, sim$Z, sim$X)
}
\references{
JD Silverman K Roche, ZC Holmes, LA David, S Mukherjee. 
  Bayesian Multinomial Logistic Normal Models through Marginally Latent Matrix-T Processes. 
  2019, arXiv e-prints, arXiv:1903.11695
}
\seealso{
\code{\link{fido_transforms}} provide convenience methods for
transforming the representation of pibblefit objects (e.g., conversion to
proportions, alr, clr, or ilr coordinates.)

\code{\link{access_dims}} provides convenience methods for accessing
dimensions of pibblefit object
}
