% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fido_transforms.R
\name{fido_transforms}
\alias{fido_transforms}
\alias{to_proportions}
\alias{to_alr}
\alias{to_ilr}
\alias{to_clr}
\alias{to_proportions.pibblefit}
\alias{to_proportions.orthusfit}
\alias{to_alr.pibblefit}
\alias{to_alr.orthusfit}
\alias{to_ilr.pibblefit}
\alias{to_ilr.orthusfit}
\alias{to_clr.pibblefit}
\alias{to_clr.orthusfit}
\title{Transform Fit fido Parameters to other representations}
\usage{
to_proportions(m)

to_alr(m, d)

to_ilr(m, V = NULL)

to_clr(m)

\method{to_proportions}{pibblefit}(m)

\method{to_proportions}{orthusfit}(m)

\method{to_alr}{pibblefit}(m, d)

\method{to_alr}{orthusfit}(m, d)

\method{to_ilr}{pibblefit}(m, V = NULL)

\method{to_ilr}{orthusfit}(m, V = NULL)

\method{to_clr}{pibblefit}(m)

\method{to_clr}{orthusfit}(m)
}
\arguments{
\item{m}{object of class pibblefit or orthusfit (e.g., output of \code{\link{pibble}}
or \code{\link{orthus}})}

\item{d}{(integer) multinomial category to take as new alr reference}

\item{V}{(matrix) contrast matrix for ILR basis to transform into to (defaults to 
\code{create_default_ilr_base(D)})}
}
\value{
object
}
\description{
These are a collection of convenience functions for transforming
fido fit objects to a number of different representations including
ILR bases, CLR coordinates, ALR coordinates, and proportions.
}
\details{
For orthus, transforms only appleid to log-ratio parameters

Note: that there is a degeneracy of representations for a covariance 
matrix represented in terms of proportions. As such the function 
\code{to_proportions} does not attempt to transform parameters Sigma
or prior Xi and instead just removes them from the pibblefit object returned.
}
