#' Data from Silverman et al. (2018) Microbiome
#' 
#' High Resolution (hourly and daily) sampling of 4 in vitro artificial gut models
#' with many technical replicates to identify technical variation. 
#' 
#' This data is at the family level and processed as in Silverman et al. 2018. Data at the sequence
#' variant level without preprocessing is given in \code{\link{mallard}}
#' 
#' @docType data
#' @name mallard_family
#' @usage data(mallard_family)
#' @format A list containing "otu_table", "sample_data", "tax_table", and "refseq".
#' @references Silverman et al. "Dynamic linear models guide design and 
#'   analysis of microbiota studies within artificial human guts". 
#'   Microbiome 2018 6:202
NULL
