% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_parameters.R
\name{set_radii}
\alias{set_radii}
\title{Change Radii Values}
\usage{
set_radii(radii_values)
}
\arguments{
\item{radii_values}{A 'data.frame' containing atomic radii values.}
}
\description{
This function enables modification of the radius values by
passing a 'data.frame' as an argument.
}
\examples{
\donttest{
library(fibos)
fibos_config()
#Loads the radius values that have been configured for code execution.
radii = get_radii()
#Displays the first three lines.
radii |> utils::head(3) |> print()
#Modifies the value of a specific radius.
radii$RAY[1] = 2.15
#Sets the radius value from a tibble.
set_radii(radii)
#Displays the first three lines.
get_radii() |> utils::head(3) |> print()
}
}
\seealso{
\code{\link[=get_radii]{get_radii()}}

\code{\link[=reset_radii]{reset_radii()}}
}
\author{
Carlos Henrique da Silveira (carlos.silveira@unifei.edu.br)

Herson Hebert Mendes Soares (hersonhebert@hotmail.com)

Joao Paulo Roquim Romanelli (joaoromanelli@unifei.edu.br)

Patrick Fleming (Pat.Fleming@jhu.edu)
}
