% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_entries.R
\name{fhir_collapse}
\alias{fhir_collapse}
\title{Collapse multiple entries}
\usage{
fhir_collapse(indexed_data_frame, columns, sep, brackets, collapse = " ")
}
\arguments{
\item{indexed_data_frame}{A data.frame/data.table with indexed multiple entries.}

\item{columns}{A character vector of column names where values should be collapsed}

\item{sep}{A character vector of length one defining the separator that was used when pasting together multiple entries in \code{\link[=fhir_crack]{fhir_crack()}}.}

\item{brackets}{A character vector of length two, defining the brackets used for the indices.}

\item{collapse}{A character vector of length one used to separate the collapsed fields. Defaults to blank space.}
}
\value{
The modified data.table/data.frame with collapsed multiple entries
}
\description{
This function collapses multiple entries that belong to the same higher level FHIR element (see examples).
}
\details{
Currently this function is only needed for very few FHIR elements where multiple values should be kept together
in the melting process. To our knowledge, this is only true for address.line elements and name.given elements.
Rather than building the cross product with all other elements in the resource as done by \code{\link[=fhir_melt]{fhir_melt()}}, these
elements should be collapsed into a single entry before melting. See examples to get a better idea of this.
}
\examples{
### First example: Keep name.given elements together
#unserialize example
bundles <- fhir_unserialize(bundles = example_bundles7)

#Have a look at the structure of example_bundles7
?example_bundles7

#Define sep and brackets
sep <- "|"
brackets <- c("[", "]")

#crack fhir resources
table_desc <- fhir_table_description(
    resource = "Patient",
    brackets = brackets,
    sep = sep
)

df <- fhir_crack(bundles = bundles, design = table_desc)
df

#name.given elements from the same name (i.e. the official vs. the nickname)
#should be collapsed

df2 <- fhir_collapse(df, columns = "name.given", sep = sep, brackets = brackets)
df2

#Next the name can be molten
fhir_melt(df2, brackets = brackets, sep = sep, columns = fhir_common_columns(df2,"name"))


### Second: Keep address line elements together
#unserialize example
bundles <- fhir_unserialize(bundles = example_bundles6)

#Have a look at the structure of example_bundles6
?example_bundles6

#Define sep and brackets
sep <- "|"
brackets <- c("[", "]")

#crack fhir resources
table_desc <- fhir_table_description(
    resource = "Patient",
    brackets = brackets,
    sep = sep
)

df <- fhir_crack(bundles = bundles, design = table_desc)
df

#Address.line elements from the same address (i.e. the work vs. the home address)
#should be collapsed

df2 <- fhir_collapse(df, columns = "address.line", sep = sep, brackets = brackets, collapse = ", ")
df2

#Next the address can be molten
fhir_melt(df2, brackets = brackets, sep = sep, columns = fhir_common_columns(df2,"address"))


}
\seealso{
\code{\link[=fhir_melt]{fhir_melt()}}
}
