% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repr.R
\name{can_repr}
\alias{can_repr}
\alias{get_repr}
\alias{set_repr}
\title{Manage Representations of a \code{fftab} Object}
\usage{
can_repr(x, repr)

get_repr(x)

set_repr(x, repr)
}
\arguments{
\item{x}{A \code{fftab} object.}

\item{repr}{For \code{can_repr()}, a character vector specifying representations (\code{"polr"}, \code{"rect"}, \code{"cplx"}).}
}
\value{
\itemize{
\item \strong{\code{can_repr()}}: Logical value (\code{TRUE} or \code{FALSE}) indicating if the object supports the specified representations.
\item \strong{\code{get_repr()}}: A character vector of current representations.
\item \strong{\code{set_repr()}}: A modified \code{fftab} object with the specified representation(s).
}
}
\description{
These functions handle representation management for a \code{fftab} object:
}
\details{
\itemize{
\item \strong{\code{get_repr()}}: Retrieve current representations.
\item \strong{\code{can_repr()}}: Check if the object supports specific representations.
\item \strong{\code{set_repr()}}: Convert the object to one or more specified representations.
}
}
\examples{
fftab(c(1, 0, -1, 0)) |> can_repr("cplx")

fftab(c(1, 0, -1, 0)) |> get_repr()

fftab(c(1, 0, -1, 0)) |> set_repr(c("polr", "rect"))

}
\seealso{
\code{\link[=to_cplx]{to_cplx()}}, \code{\link[=has_cplx]{has_cplx()}}
}
