% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfl_api.R
\name{mfl_getendpoint}
\alias{mfl_getendpoint}
\title{GET any MFL endpoint}
\usage{
mfl_getendpoint(conn, endpoint, ...)
}
\arguments{
\item{conn}{the list object created by \code{mfl_connect()}}

\item{endpoint}{a string defining which endpoint to return from the API}

\item{...}{Arguments which will be passed as "argumentname = argument" in an HTTP query parameter}
}
\value{
A list object containing the query, response, and parsed content.
}
\description{
Create a GET request to any MFL export endpoint.
}
\details{
This function will read the connection object and automatically pass in the rate-limiting, league ID (L), authentication cookie, and/or API key (APIKEY) if configured in the connection object.

The endpoint names and HTTP parameters (i.e. argument names) are CASE SENSITIVE and should be passed in exactly as displayed on the MFL API reference page.

Check out the vignette for more details and example usage.
}
\seealso{
\url{https://api.myfantasyleague.com/2020/api_info?STATE=details}

\code{vignette("mfl_getendpoint")}
}
