% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/views.R
\name{view_on_joint_distribution}
\alias{view_on_joint_distribution}
\alias{view_on_joint_distribution.default}
\alias{view_on_joint_distribution.matrix}
\alias{view_on_joint_distribution.xts}
\alias{view_on_joint_distribution.tbl_df}
\title{Views on Joint Distribution}
\usage{
view_on_joint_distribution(x, simul, p)

\method{view_on_joint_distribution}{default}(x, simul, p)

\method{view_on_joint_distribution}{matrix}(x, simul, p)

\method{view_on_joint_distribution}{xts}(x, simul, p)

\method{view_on_joint_distribution}{tbl_df}(x, simul, p)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{simul}{An univariate or multivariate simulated panel.}

\item{p}{An object of the \code{ffp} class.}
}
\value{
A \code{list} of the \code{view} class.
}
\description{
Helper to construct constraints on the entire distribution.
}
\details{
\itemize{
\item \code{simul} must have the same number of columns than \code{x}
\item \code{p} should have the same number of rows that \code{simul}.
}
}
\examples{
set.seed(1)
library(ggplot2)

# Invariants
ret <- diff(log(EuStockMarkets))
n <- nrow(ret)

#' Prior probability distribution
prior <- rep(1 / n, n)

# Simulated marginals
simul <- bootstrap_scenarios(ret, as_ffp(prior), as.double(n))

views <- view_on_joint_distribution(x = ret, simul = simul, p = prior)
views

ep <- entropy_pooling(p = prior, Aeq = views$Aeq, beq = views$beq, solver = "nlminb")
autoplot(ep)

# location matches
colMeans(simul)
ffp_moments(x = ret, p = ep)$mu

# dispersion matches
cov(simul)
ffp_moments(x = ret, p = ep)$sigma
}
