% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda-pp-test.R
\name{eda_pp_test}
\alias{eda_pp_test}
\title{Phillips–Perron Unit Root Test}
\usage{
eda_pp_test(data, alpha = 0.05)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}
}
\value{
A list containing the test results, including:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{alpha}: The significance level as specified in the \code{alpha} argument.
\item \code{null_hypothesis}: A string describing the null hypothesis.
\item \code{alternative_hypothesis}: A string describing the alternative hypothesis.
\item \code{statistic}: The PP test statistic.
\item \code{p_value}: Reported p-value from the test. See the details for more information.
\item \code{reject}: If \code{TRUE}, the null hypothesis was rejected at significance \code{alpha}.
}
}
\description{
Applies the Phillips–Perron (PP) test to check for a unit root in annual
maximum series data. The null hypothesis assumes the time series contains a
unit root (also known as a stochastic trend). The alternative hypothesis is that
the time series is trend-stationary with a deterministic linear trend.
}
\details{
The implementation of this test is based on the 'aTSA' package, which
interpolates p-values from the table of critical values presented in Fuller W.
A. (1996). The critical values are only available for \eqn{\alpha \geq 0.01}.
Therefore, a reported p-value of 0.01 indicates that \eqn{p \leq 0.01}.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
eda_pp_test(data)

}
\references{
Fuller, W. A. (1976). Introduction to Statistical Time Series. New York:
John Wiley and Sons

Phillips, P. C. B.; Perron, P. (1988). Testing for a Unit Root in Time Series
Regression. Biometrika, 75 (2): 335-346
}
\seealso{
\code{\link[=eda_kpss_test]{eda_kpss_test()}}
}
