% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHistory.R
\name{getHistory}
\alias{getHistory}
\title{Get history of a bank by FDIC certificate number or name}
\usage{
getHistory(CERT_or_NAME = NULL, fields, CERT = TRUE, limit = 10000)
}
\arguments{
\item{CERT_or_NAME}{Either the FDIC certificate number or the name of the bank for which to retrieve history information.}

\item{fields}{A character vector specifying the fields to include in the output.}

\item{CERT}{A logical value indicating whether the value in CERT_or_NAME is a FDIC certificate number (default is TRUE).}

\item{limit}{An integer indicating the maximum number of records to retrieve (default and max is 10000).}
}
\value{
A data frame containing the requested history information for the specified bank.
}
\description{
This function retrieves the history of a bank by either its FDIC certificate number or name. The user can specify which fields to include in the output.
}
\examples{
getHistory(CERT_or_NAME = 3850, c("INSTNAME","CERT","PCITY","PSTALP","PZIP5"))
}
