% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.lpcr.R
\name{predict.lpcr}
\alias{predict.lpcr}
\title{Elastic Prediction for functional logistic PCR Model}
\usage{
\method{predict}{lpcr}(object, newdata = NULL, y = NULL, ...)
}
\arguments{
\item{object}{Object of class inheriting from "elastic.pcr.regression"}

\item{newdata}{An optional matrix in which to look for variables with which to predict. If omitted, the fitted values are used.}

\item{y}{An optional vector of labels to calculate PC. If omitted, PC is NULL}

\item{...}{additional arguments affecting the predictions produced}
}
\value{
Returns a list containing
\item{y_pred}{predicted probabilities of the class of newdata}
\item{y_labels}{class labels of newdata}
\item{PC}{probability of classification}
}
\description{
This function performs prediction from an elastic logistic fPCR regression model
with phase-variability
}
\references{
J. D. Tucker, J. R. Lewis, and A. Srivastava, “Elastic
Functional Principal Component Regression,” Statistical Analysis and Data
Mining, 10.1002/sam.11399, 2018.
}
\keyword{alignment}
\keyword{regression}
\keyword{srvf}
