% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kCFC.R
\name{kCFC}
\alias{kCFC}
\title{Functional clustering and identifying substructures of longitudinal data using kCFC.}
\usage{
kCFC(
  y,
  t,
  k = 3,
  kSeed = 123,
  maxIter = 125,
  optnsSW = list(methodMuCovEst = "smooth", FVEthreshold = 0.9, methodBwCov = "GCV",
    methodBwMu = "GCV"),
  optnsCS = list(methodMuCovEst = "smooth", FVEthreshold = 0.7, methodBwCov = "GCV",
    methodBwMu = "GCV")
)
}
\arguments{
\item{y}{A list of \emph{n} vectors containing the observed values for each individual. Missing values specified by \code{NA}s are supported for dense case (\code{dataType='dense'}).}

\item{t}{A list of \emph{n} vectors containing the observation time points for each individual corresponding to y.}

\item{k}{A scalar defining the number of clusters to define; default 3. Values that define very small clusters (eg.cluster size <=3) will potentially err.}

\item{kSeed}{A scalar valid seed number to ensure replication; default: 123}

\item{maxIter}{A scalar defining the maximum number of iterations allowed; default 20, common for both the simple kmeans initially and the subsequent k-centres}

\item{optnsSW}{A list of options control parameters specified by \code{list(name=value)} to be used for sample-wide FPCA; by default: "list( methodMuCovEst ='smooth', FVEthreshold= 0.90, methodBwCov = 'GCV', methodBwMu = 'GCV' )". See `Details in ?FPCA'.}

\item{optnsCS}{A list of options control parameters specified by \code{list(name=value)} to be used for cluster-specific FPCA; by default:  "list( methodMuCovEst ='smooth', FVEthreshold= 0.70, methodBwCov = 'GCV', methodBwMu = 'GCV' )". See `Details in ?FPCA'.}
}
\value{
A list containing the following fields:
\item{cluster}{A vector of levels 1:k, indicating the cluster to which each curve is allocated.} 
\item{fpcaList}{A list with the fpcaObj for each separate cluster.} 
\item{iterToConv}{A number indicating how many iterations where required until convergence.}
}
\description{
Functional clustering and identifying substructures of longitudinal data using kCFC.
}
\examples{
\donttest{
data(medfly25) 
Flies <- MakeFPCAInputs(medfly25$ID, medfly25$Days, medfly25$nEggs)
kcfcObj <- kCFC(Flies$Ly[1:150], Flies$Lt[1:150], # using only 150 for speed consideration 
                 optnsSW = list(methodMuCovEst = 'smooth', userBwCov = 2, FVEthreshold = 0.90),
                 optnsCS = list(methodMuCovEst = 'smooth', userBwCov = 2, FVEthreshold = 0.70))
}
}
\references{
\cite{Jeng-Min Chiou, Pai-Ling Li, "Functional clustering and identifying substructures of longitudinal data." Journal of the Royal Statistical Society 69 (2007): 679-699}
}
