% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_variation_depth.R
\name{total_variation_depth}
\alias{total_variation_depth}
\title{Total Variation Depth and Modified Shape Similarity Index}
\usage{
total_variation_depth(dts)
}
\arguments{
\item{dts}{A matrix or dataframe of size \eqn{n} observations/curves by \eqn{p} domain/evaluation
points.}
}
\value{
Returns a list containing the following
  \item{\code{tvd}}{the total variation depths of the observations of \code{dts}}
  \item{\code{mss}}{the modified shape similarity index of the observations of \code{dts}}
}
\description{
This function computes the total variation depth (tvd) and the modified shape similarity index (mss)
proposed in Huang and Sun (2019) \doi{10.1080/00401706.2019.1574241}.
}
\details{
This function computes the total variation depth (TVD) and modified shape
similarity (MSS) index of a univariate functional data. The definition of the
estimates of TVD and MSS can be found in Huang and Sun (2019)
\doi{10.1080/00401706.2019.1574241}.
}
\examples{
dt6 <- simulation_model6()
tvd_object <- total_variation_depth(dt6$data)
}
\references{
Huang, H., & Sun, Y. (2019). A decomposition of total variation depth for
understanding functional outliers. \emph{Technometrics}, 61(4), 445-458.
}
\seealso{
\code{\link{tvd_mss}} for outlier detection using TVD and MSS.
}
\author{
Oluwasegun Ojo
}
