% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lqd2quantile.R
\name{lqd2quantile}
\alias{lqd2quantile}
\title{Function for converting log quantile densities to quantile functions}
\usage{
lqd2quantile(
  lqd,
  lqdSup = seq(0, 1, length.out = length(lqd)),
  lb = 0,
  useSplines = TRUE
)
}
\arguments{
\item{lqd}{log quantile density on lqdSup}

\item{lqdSup}{support for lqd domain - must begin at 0 and end at 1}

\item{lb}{lower bound of support for Density domain - default is 0.}

\item{useSplines}{fit spline to the lqd when doing the numerical integration (default: TRUE)}
}
\value{
quantile values on lqdSup
}
\description{
Function for converting log quantile densities to quantile functions
}
\examples{
x <- seq(1,3,length.out =512)
y.lqd <- rep(log(2), times = 512)
y <- lqd2quantile(lqd = y.lqd, lb = 1) # should equate # seq(1, 3, length.out = 512)
}
\references{
\cite{Functional Data Analysis for Density Functions by Transformation to a Hilbert space, Alexander Petersen and Hans-Georg Mueller, 2016}
}
