% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{trunc2norm}
\alias{trunc2norm}
\title{Convert truncated normal to normal}
\usage{
trunc2norm(x, min = NULL, max = NULL, mu = mean(x), sd = stats::sd(x))
}
\arguments{
\item{x}{the truncated normally distributed vector}

\item{min}{the minimum of the truncated distribution (calculated from x if not given)}

\item{max}{the maximum of the truncated distribution (calculated from x if not given)}

\item{mu}{the mean of the distribution to return (calculated from x if not given)}

\item{sd}{the SD of the distribution to return (calculated from x if not given)}
}
\value{
a vector with a uniform distribution
}
\description{
Convert a truncated normal distribution to a normal (gaussian) distribution
}
\examples{

x <- truncnorm::rtruncnorm(10000, 1, 7, 3.5, 2)
y <- trunc2norm(x, 1, 7)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
