% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qq.R
\name{qqplot}
\alias{qqplot}
\title{Creates a Q-Q plot}
\usage{
qqplot(
  x,
  y,
  plot.it = TRUE,
  xlab = deparse1(substitute(x)),
  ylab = deparse1(substitute(y)),
  ...
)
}
\arguments{
\item{x}{First sample for \code{qqplot}.}

\item{y}{Second sample for \code{qqplot}.}

\item{plot.it}{Should the plot be created.}

\item{xlab}{x label for plot.}

\item{ylab}{y label for plot.}

\item{...}{Other arguments passed to \code{plot()}}
}
\value{
list with sorted samples, interpolated to be same size.
}
\description{
Faster alternative to \code{stats::qqplot()}. For more than 1e5 points
we remove excess points, that would not be visible in the plot, since the
points are so close.
}
\examples{
qqplot(stats::runif(1e6),stats::runif(1e6))
}
\keyword{qq}
\keyword{qqplot}
\keyword{visualization}
