% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{confusion}
\alias{confusion}
\title{Get confusion table for fastLink objects}
\usage{
confusion(object, threshold)
}
\arguments{
\item{object}{A 'fastLink' object or list of fastLink objects. Can only be run if 'return.all = TRUE' in 'fastLink().'}

\item{threshold}{The matching threshold above which a pair is a true match. Default is .85}
}
\value{
'confusion()' returns two tables - one calculating the confusion table, and another
calculating a series of additional summary statistics.
}
\description{
Calculate confusion table after running fastLink().
}
\examples{
\dontrun{
 out <- fastLink(
 dfA = dfA, dfB = dfB,
 varnames = c("firstname", "middlename", "lastname"),
 stringdist.match = c("firstname", "middlename", "lastname"),
 partial.match = c("firstname", "lastname", "streetname"),
 return.all = TRUE)

 ct <- confusion(out)
}

}
\author{
Ted Enamorado <ted.enamorado@gmail.com> and Ben Fifield <benfifield@gmail.com>
}
