% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_annual_symbols.R
\name{plot_annual_symbols}
\alias{plot_annual_symbols}
\title{Plot daily streamflow data symbols by year}
\usage{
plot_annual_symbols(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  symbols = Symbol,
  station_number,
  water_year_start = 1,
  start_year,
  end_year,
  months = 1:12,
  include_title = FALSE,
  plot_type = "dayofyear"
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{symbols}{Name of column in \code{data} that contains symbols. Only required if symbols column name is not 
'Symbol' (default). Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank or set well before start date (i.e.
\code{1800}) to use from the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank or set well after end date (i.e.
\code{2100}) to use up to the last year of the source data.}

\item{months}{Numeric vector of months to include in plotting For example, \code{3} for March, \code{6:8} for Jun-Aug or 
\code{c(10:12,1)} for first four months (Oct-Jan) when \code{water_year_start = 10} (Oct). Default plots all 
months (\code{1:12}).}

\item{include_title}{Logical value to indicate adding the group/station number to the plot, if provided. Default \code{FALSE}.}

\item{plot_type}{Character. One of \code{c('dayofyear','count','percent'}. With 'dayofyear' plot (default), the day of year for
each year of data are coloured by symbols or missing dates are colours for each flow day of year. For 'count' and
'percent' plots, the total count or percent of all symbols or missing dates per year are displayed.}
}
\value{
A list of ggplot2 objects with the following for each station provided:
  \item{Annual_Symbols}{a plot that contains data symbols and missing dates}
}
\description{
Plots data symbols for a daily data set by year, either by day of year, total days, or percent of year (see
    \code{plot_type} argument. A column of symbols is required, default \code{symbols = 'Symbol'}. For HYDAT data, symbols
    include: 'E' Estimate, 'A' Partial Day, 'B' Ice Conditions, 'D' Dry, and 'R' Revised. Other symbols or categories may be 
    used to colour points of plot. Returns a list of plots.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Plot annual symbol counts from a data frame and data argument
flow_data <- tidyhydat::hy_daily_flows(station_number = "08NM116")
plot_annual_symbols(data = flow_data)

# Plot annual symbol counts using station_number argument with defaults
plot_annual_symbols(station_number = "08NM116")

# Plot annual symbol percentages using station_number argument and plot by annual counts
plot_annual_symbols(station_number = "08NM116",
                    plot_type = "count")
                  
}
}
