% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance.chisq.datatable.R
\name{balance.chisq.datatable}
\alias{balance.chisq.datatable}
\title{Count-balance chi-square diagnostics across factors}
\usage{
balance.chisq.datatable(formula, data, force_factors = TRUE, correct = FALSE)
}
\arguments{
\item{formula}{A model formula \code{y ~ A + B (+ C ...)}; the response is ignored.}

\item{data}{A data frame with the variables.}

\item{force_factors}{Logical; if TRUE, coerces RHS predictors to factors.}

\item{correct}{Logical; continuity correction for 2x2 tables in \code{chisq.test} (default FALSE).}
}
\value{
A data.frame with one row per factor combination (\code{Effect}) and columns:
\code{n}, \code{ChiSq} (4 decimals), \code{df}, \code{p.chisq} (4 decimals), \code{OK}.
}
\description{
For one factor: chi-square goodness-of-fit vs equal proportions.
For two factors: chi-square test of independence.
For three or more: log-linear independence (Poisson, main effects only) via deviance and df.
}
\details{
Uses \code{stats::chisq.test} for 1–2 factors. For 3+ factors, prefers \code{MASS::loglm}
if available; otherwise falls back to a Poisson GLM on the count table.
}
\examples{
\dontrun{
balance.chisq.datatable(liking ~ gender + condition + age_cat, data = mimicry)
}
}
\seealso{
\code{\link{plan.diagnostics}}
}
