% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.pafm.R
\name{summary.pafm}
\alias{summary.pafm}
\title{summary \code{"pafm"} object.}
\usage{
\method{summary}{pafm}(object, digits = max(3, .Options$digits - 3), ...)
}
\arguments{
\item{object}{\code{"pafm"} object created by
\code{paFm}.}

\item{digits}{integer indicating the number of decimal places. Default is 3.}

\item{...}{Other arguments for \code{print} methods.}
}
\value{
Returns an object of class \code{summary.pafm}. 
The print method for class \code{summary.pafm} outputs the means of the
specific returns of the factors.
}
\description{
Generic function of summary method for \code{paFm}.
}
\examples{
# load data from the database
data(managers, package = 'PerformanceAnalytics')

# fit the factor model with LS
fit.ts <- fitTsfm(asset.names = colnames(managers[,(1:6)]), 
                  factor.names = c("EDHEC LS EQ","SP500 TR"),
                  data = managers)
  
fm.attr <- paFm(fit.ts)
summary(fm.attr)

}
\author{
Yi-An Chen.
}
