% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INGARCH.R
\name{glance.INGARCH}
\alias{glance.INGARCH}
\title{Glance a INGARCH model}
\format{
A data frame with 1 row, with columns:
\describe{
  \item{sigma2}{The unbiased variance of residuals. Calculated as `sum(residuals^2) / (num_observations - num_pararameters + 1)`}
  \item{log_lik}{The log-likelihood}
  \item{AIC}{Akaike information criterion}
  \item{BIC}{Bayesian information criterion}
}
}
\usage{
\method{glance}{INGARCH}(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
A one row tibble summarising the model's fit.
}
\description{
Construct a single row summary of the INGARCH model.
}
\examples{
tsibbledata::aus_production |>
  fabletools::model(manual_ing = INGARCH(Beer ~ pq(1,1))) |>
  dplyr::select(manual_ing) |>
  glance()

}
