% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLARMA.R
\name{forecast.GLARMA}
\alias{forecast.GLARMA}
\title{Forecast a model from the fable package}
\usage{
\method{forecast}{GLARMA}(object, new_data, ...)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{new_data}{Tsibble, it has to contains the time points and exogenous regressors to produce forecasts for.}

\item{...}{Other arguments passed to methods}
}
\value{
A list of forecasts.
}
\description{
Produces forecasts from a trained model.
}
\details{
Predict future observations based on a fitted GLM-type model for time series of counts.
Futher informations about the forecast method can be obtained typing ?glarma::forecast
}
\examples{
tsibbledata::aus_production |>
  fabletools::model(manual_gla = GLARMA(Beer ~ pq(1,0))) |>
  dplyr::select(manual_gla) |>
  fabletools::forecast(h = 2)
}
