% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyaMLE.R
\name{polyaMLE}
\alias{polyaMLE}
\title{Obtain MLE of marginal Dirichlet-multinomial likelihood}
\usage{
polyaMLE(
  D,
  init = NA,
  method = "Newton_Raphson",
  epsilon = 1e-04,
  print_progress = FALSE
)
}
\arguments{
\item{D}{matrix (JxK) of counts; each row is a sample from a MN distribution with K categories}

\item{init}{If NA, use method moment matching procedure to obtain good init values}

\item{method}{"Newton_Raphson", "fixed_point", "separate", "precision_only"}

\item{epsilon}{convergence diagnostic}

\item{print_progress}{if TRUE, print progress to screen}
}
\value{
mle of prior concentration from marginal Dirichlet-multinomial likelihood
}
\description{
This function retuns the MLE of the prior concentration from a marginal Dirichlet-multinomial
likelihood. Default method iterates a Newton-Raphson algorithm until convergence.
}
