% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrub.R
\name{scrub}
\alias{scrub}
\title{Data-driven scrubbing}
\usage{
scrub(X, method = c("projection", "DVARS"), ...)
}
\arguments{
\item{X}{A \eqn{T} by \eqn{V} numeric matrix representing an fMRI run. There should
not be any missing data (\code{NA} or \code{NaN}).}

\item{method}{\code{"projection"} (default) or \code{"DVARS"}}

\item{...}{Additional arguments to the specific scrubbing function: see
\code{\link{pscrub}} or \code{\link{DVARS}}.}
}
\value{
A list with components
\describe{
\item{measure}{A length \eqn{T} vector or data.frame with \eqn{T} rows, giving the outlyingness measure(s)}
\item{measure_info}{Describes the outlyingness measure(s)}
\item{outlier_cutoff}{The outlier cutoff value(s).}
\item{outlier_flag}{A length \eqn{T} vector or data.frame with \eqn{T} rows,  where \code{TRUE} indicates suspected outlier presence.}
}
}
\description{
Performs projection scrubbing or DVARS scrubbing, and optionally thresholds
to identify artifactual time points.
}
