% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_ezmmek_sat_fit.R
\name{new_ezmmek_sat_fit}
\alias{new_ezmmek_sat_fit}
\title{new_ezmmek_sat_fit}
\usage{
new_ezmmek_sat_fit(
  std.data.fn,
  act.data.fn,
  ...,
  km = NULL,
  vmax = NULL,
  method = NA
)
}
\arguments{
\item{std.data.fn}{Standard data file as character string}

\item{act.data.fn}{Activity data file as character string}

\item{...}{User defined column names to join and group std.data.fn and act.data.fn}

\item{km}{Starting value to estimate km. Default value is median of 'sub.conc' values}

\item{vmax}{Starting value to estimate vmax. Default value is max activity calculated}

\item{method}{Enzyme assay protocol. Must define method as 'isc' or 'ibc'}
}
\description{
Creates dataframe containing calibrated enzyme activity data and Michaelis-Menton fit of class 'new_ezmmek_sat_fit'
}
\examples{
\dontrun{new_obj <- new_ezmmek_sat_fit("data/tyson_std_04172020.csv",
  "data/tyson_sat_steen_04172020.csv",
  site_name,
  std_type,
  km = NULL,
  vmax = NULL,
  method = "isc")
new_obj <- new_ezmmek_sat_fit("data/tyson_std_04172020.csv",
  "data/tyson_sat_german_04172020.csv",
  site_name,
  std_type,
  km = NULL,
  vmax = NULL,
  method = "ibc")}
}
