% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_ezmmek_act_group.R
\name{new_ezmmek_act_group}
\alias{new_ezmmek_act_group}
\title{new_ezmmek_act_group}
\usage{
new_ezmmek_act_group(act.data.fn, ..., method = NA, columns = NULL)
}
\arguments{
\item{act.data.fn}{Activity data file as character string}

\item{...}{User defined column names to join std.data.fn and act.data.fn}

\item{method}{Enzyme assay protocol. Must define method as 'isc' or 'ibc'}

\item{columns}{Column names carried over from parent functions if parent functions used}
}
\description{
Groups raw activity data by user-defined columns
}
\examples{
\dontrun{new_obj <- new_ezmmek_act_group("data/tyson_sat_steen_04172020.csv,
  site_name,
  std_type,
  method = "isc",
  columns = NULL)
new_obj <- new_ezmmek_act_group("data/tyson_sat_german_04172020.csv,
  site_name,
  std_type,
  method = "ibc",
  columns = NULL)}
}
