% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot heatmap of raw data}
\usage{
plot_heatmap(
  data = NULL,
  pID_values = NULL,
  trial_values = NULL,
  bg_image = NULL,
  res = c(0, 1920, 0, 1080),
  flip_y = FALSE,
  plot_type = "density",
  alpha_range = c(0.1, 0.8),
  plot_header = FALSE
)
}
\arguments{
\item{data}{data in standard raw data form (time, x, y, trial)}

\item{pID_values}{specify particular values within 'pID' to plot data from certain participants}

\item{trial_values}{specify particular values within 'trial' to plot data from certain trials}

\item{bg_image}{The filepath of a PNG image to be added to the plot, for example to show a screenshot of the task.}

\item{res}{resolution of the display to be shown, as a vector (xmin, xmax, ymin, ymax)}

\item{flip_y}{reverse the y axis coordinates (useful if origin is top of the screen)}

\item{plot_type}{Specify the nature of the data displayed. Either "density" (default) or "hex"}

\item{alpha_range}{a pair of values between 0 and 1. The first is a cut off, whereby lower values are not displayed. The second value sets the transparancy of the visible poitns.}

\item{plot_header}{display the header title text which explains graphical features of the plot.}
}
\value{
a plot of the raw data
}
\description{
Plots a heatmap of raw data.
}
\examples{
\donttest{
data <- combine_eyes(HCL)
# plot all trials data
plot_heatmap(data, pID_values = 118, alpha_range = c(0.3,0.8))

#plot one trial
plot_heatmap(data, trial_values = 1)

}
}
