% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_preamble.R
\name{read_preamble}
\alias{read_preamble}
\title{Reads edf-file preamble}
\usage{
read_preamble(file, fail_loudly = TRUE)
}
\arguments{
\item{file}{name of the EDF file}

\item{fail_loudly}{logical, whether lack of compiled library means
error (\code{TRUE}, default) or just warning (\code{FALSE}).}
}
\value{
a character vector but with added class \code{eyelinkPreamble} to simplify printing.
}
\description{
Read the preamble of the EDF file and parses it into an reading-friendly format
}
\examples{
\donttest{
 if (eyelinkReader::compiled_library_status()) {
  read_preamble(system.file("extdata", "example.edf", package = "eyelinkReader"))
}
}
}
