% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_extract.R
\name{set_zero}
\alias{set_zero}
\title{Set to zero specific rows and columns of a matrix}
\usage{
set_zero(df, orig = NULL, dest = NULL, wiotype = NULL, invert = FALSE)
}
\arguments{
\item{df}{A matrix with named rows and columns.}

\item{orig}{A vector of integers with position of rows or a list of strings
with codes of country and sector of origin.}

\item{dest}{A vector of integers with position of columns or a list of
strings with codes of country and sector of destination.}

\item{wiotype}{String, type of \code{wio}. Required if origin or destination
is specified with lists of codes.}

\item{invert}{Boolean: FALSE (default) to set to zero the specified
countries and sectors, or TRUE to set to zero the non-specified countries
and sectors.}
}
\value{
The same matrix with specific rows and columns set to zero.
}
\description{
Sets to zero specific rows and columns of a matrix, to
include and exclude specific geographical and sector effects.
}
\examples{
wio <- make_wio("wiodtest")
# Set to zero Spanish exports of intermediates of manufacturing to
# non EU27 countries (for any sector of destination) in the coefficient
# matrix A
set_zero(wio$A, list("ESP", "MANUF"), list("NONEU27", "TOTAL"), "wiodtest")
# Set to zero Spanish exports of intermediates (extraction matrix of Spain)
set_zero(wio$A, list("ESP", "TOTAL"), list("WLDxESP", "TOTAL"), "wiodtest")
}
