% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_blocks.R
\name{bkt}
\alias{bkt}
\title{Block transpose matrix}
\usage{
bkt(df)
}
\arguments{
\item{df}{A block matrix with named rows and columns. Names of countries
and sectors are automatically identified.}
}
\value{
Block transposed version of \code{df}.
}
\description{
Transpose a matrix by blocks, so \code{block(s,r)} becomes \code{block(r,s)}, but
elements within each block are not transposed.
}
\details{
\code{bkt()} takes a matrix of \verb{c1 x c2} blocks where each
block has a dimension \verb{s1 x s2} and transposes its blocks. Block
\code{B21} becomes \code{B12}, \code{B31} becomes \code{B13}, etc., but
blocks are not altered internally. For instance, a matrix with rows
5 exporting countries of 4 sectors each and columns with 3
importing countries with 2 aggregated sectors, i.e., a
(5 x 4) x (3 x 2), matrix will become a (3 x 4) x (5 x 2) matrix. The
rows will now show the importing countries and the sectors they import
from, and the columns will show the the exporting countries and the
sectors they export from.
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
# Matrix Ym (exports of final products)
wio$Ym
# Block transposed version of Ym (imports of final products)
bkt(wio$Ym)
}
\seealso{
\code{\link[=bktt]{bktt()}}.
}
