% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgpd.R
\name{mgpd}
\alias{mgpd}
\alias{dmgpd}
\alias{pmgpd}
\alias{qmgpd}
\alias{rmgpd}
\title{The MGPD distribution}
\usage{
dmgpd(x, xi, sigma, u, mu, eta, w, log = FALSE)

pmgpd(q, xi, sigma, u, mu, eta, w, lower.tail = TRUE)

qmgpd(p, xi, sigma, u, mu, eta, w, lower.tail = TRUE)

rmgpd(N, xi, sigma, u, mu, eta, w)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{xi}{shape parameter of the tail GPD (scalar).}

\item{sigma}{scale parameter of the tail GPD (scalar).}

\item{u}{threshold parameter of the tail GPD (scalar).}

\item{mu}{means of the gamma mixture components (vector).}

\item{eta}{shapes of the gamma mixture components (vector).}

\item{w}{weights of the gamma mixture components (vector). Must sum to one.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P(X\leq x)} otherwise \eqn{P(X>x)}.}

\item{p}{vector of probabilities.}

\item{N}{number of observations.}
}
\value{
\code{dmgpd} gives the density, \code{pmgpd} gives the distribution function, \code{qmgpd} gives the quantile function, and \code{rmgpd} generates random deviates. The length of the result is determined by \code{N} for \code{rmgpd} and by the length of \code{x}, \code{q} or \code{p} otherwise.
}
\description{
Density, distribution function, quantile function and random generation for the MGPD distribution.
}
\details{
The MGPD distribution is an extreme value mixture model with density
\deqn{f_{MGPD}(x|\xi,\sigma,u,\mu,\eta,w)=\left\{\begin{array}{ll} f_{MG}(x|\mu,\eta,w), & x\leq u \\ (1-F_{MG}(u|\mu,\eta,w))f_{GPD}(x|\xi,\sigma,u), &\mbox{otherwise},  \end{array}\right.} where \eqn{f_{MG}} is the density of the mixture of Gammas, \eqn{F_{MG}} is the distribution function of the mixture of Gammas and \eqn{f_{GPD}} is the density of the Generalized Pareto Distribution, i.e.
\deqn{f_{GPD}(x|\xi,\sigma,u)=\left\{\begin{array}{ll} 1- (1+\frac{\xi}{\sigma}(x-u))^{-1/\xi}, & \mbox{if } \xi\neq 0,\\ 1- \exp\left(-\frac{x-u}{\sigma}\right), & \mbox{if } \xi = 0, \end{array}\right.}
where \eqn{\xi} is a shape parameter, \eqn{\sigma > 0} is a scale parameter and \eqn{u>0} is a threshold.
}
\examples{
dmgpd(3, xi = 0.5, sigma = 2,5, u = 5, mu = c(2,3), eta = c(1,2), w = c(0.3,0.7))

}
\references{
do Nascimento, Fernando Ferraz, Dani Gamerman, and Hedibert Freitas Lopes. "A semiparametric Bayesian approach to extreme value estimation." Statistics and Computing 22.2 (2012): 661-675.
}
