% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{TruncGauss.kernel}
\alias{TruncGauss.kernel}
\title{Truncated Gaussian kernel function}
\usage{
TruncGauss.kernel(x, sigma = 1)
}
\arguments{
\item{x}{a vector.}

\item{sigma}{the standard deviation of the truncated gaussian kernel.}
}
\description{
Truncated Gaussian kernel function
}
\details{
Truncated Gaussian Kernel with \eqn{sigma} the standard deviation parameter with default value \eqn{1}.
\deqn{
  K(x) = (1/{sigma*sqrt(2 \pi)}  exp(-(x/sigma)^2/2)) (abs(x) <= 1)
}
We recommend a critical value of 3.6 for this kernel with sigma=1.
}
\examples{
plot(function(x) TruncGauss.kernel(x), -2, 2,
main = " Truncated Gaussian kernel")

}
