% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expRename.R
\name{expRename}
\alias{expRename}
\title{Change the name of elements that an experiment contains}
\usage{
expRename(e, elements = list(), name = NULL)
}
\arguments{
\item{e}{Input experiment}

\item{elements}{A list of arrays of strings containing the new names. The old
name will be specified as the name of the element in such array, and the name
for the parameter, method or problem will be given by the name of the
corresponding object in the list.
If a name is not present in the set of parameter names or parameter values,
it will be ignored.}

\item{name}{The name of the new experiment. If NULL, the previous name will
be used.}
}
\value{
A modified exreport experiment object with some changes on the name of
the elements.
}
\description{
This function change the name of problems, methods or parameter values that
an existing experiment object contains.
}
\examples{
# We load the wekaExperiment problem as an experiment and then change the name
# of one value for the parameter discretization and for one method.

experiment <- expCreate(wekaExperiment, name="test", parameter="fold")
expRename(experiment, list(featureSelection = c("no"="false"),
                           method=c("RandomForest"="RndForest")))
}

