% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expRemoveDuplicated.R
\name{expRemoveDuplicated}
\alias{expRemoveDuplicated}
\title{Remove duplicated rows from an experiment}
\usage{
expRemoveDuplicated(e, tol = 1e-09)
}
\arguments{
\item{e}{The experiment to be analised}

\item{tol}{The tolerance for numeric values to check if two outputs are
numerically equal or not.}
}
\value{
an experiment object
}
\description{
This function removes duplicated rows of a given experiment attending to the
interaction of methods, problems and parameters (but no outputs).
}
\details{
The duplicated rows found are compared among themselves to determine if there
is divergence between the outputs, if the rows are not consistent a warning is
raised to note this difference.
}
\examples{
# We duplicate some of the rows of a given experiment:
e <- expCreate(wekaExperiment, parameters="fold", name="Test Experiment")
redundant <- expCreate(wekaExperiment[wekaExperiment$method=="NaiveBayes",],
                       parameters="fold", name="Test Experiment")
e2 <- expConcat(e,redundant)

# Now we remove those duplicates:
expRemoveDuplicated(e2)
}

