### R code from vignette source 'expint.Rnw'

###################################################
### code chunk number 1: expint.Rnw:76-78
###################################################
library(expint)
options(width = 60)


###################################################
### code chunk number 2: expint.Rnw:242-243
###################################################
expint(c(1.275, 10, 12.3), order = 1:3)


###################################################
### code chunk number 3: expint.Rnw:257-260
###################################################
expint_E1(1.275)
expint_E2(10)
expint_En(12.3, order = 3L)


###################################################
### code chunk number 4: expint.Rnw:265-267
###################################################
expint_Ei(5)
-expint_E1(-5)     # same


###################################################
### code chunk number 5: expint.Rnw:382-383
###################################################
op <- options() # remember default number of digits


###################################################
### code chunk number 6: expint.Rnw:385-388
###################################################
options(digits = 20)
gammainc(1.2, 3)
gamma(1.2) * pgamma(3, 1.2, 1, lower = FALSE)


###################################################
### code chunk number 7: expint.Rnw:390-391
###################################################
options(op)     # restore defaults


###################################################
### code chunk number 8: expint.Rnw:449-453
###################################################
x <- c(1.275, 10, 12.3)
n <- 1:10
structure(t(outer(x, n, expint)),
          dimnames = list(n, paste("x =", x)))


###################################################
### code chunk number 9: expint.Rnw:458-462
###################################################
a <- c(-1.5, -1, -0.5, 1)
x <- 1:10
structure(t(outer(a, x, gammainc)),
          dimnames = list(x, paste("a =", a)))


