% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{Ydiagnostics}
\alias{Ydiagnostics}
\title{Informative plots for Y and Yhat}
\usage{
Ydiagnostics(Y, Yhat, ...)
}
\arguments{
\item{Y}{R object representing response,
coercible to a vector.}

\item{Yhat}{R object representing estimate,
coercible to a vector.
The length of Y and Yhat must be equal.}

\item{...}{Options for \code{\link[stats]{cor}} function.
The defaults are use = "everything" and
method = "pearson".}
}
\value{
Invisibly returns TRUE; this routine
         is only used for its graphical side effects
         described in Details.
}
\description{
This function presents diagnostic plots of estimate Yhat
and response Y.
}
\details{
The plots shown are:

\itemize{
  \item{Y vs Yhat.  Under a perfect noise-free fitting,
         this would be a straight line with
         the points lined up on the red line, and the
         correlation wpuld be 1.0000.}
  \item{Y, Yhat and Y-Yhat (residual) time domain plots.
         The time steps are in samples.}
  \item{These show the ACF for the original Y, the residual,
         and |residual|.  The latter helps identify
         nonlinearity in the residual.}
}
}
\examples{
# The order here looks backwards, but is chosen to
# simulate a typical pair - Yhat will normally have
# a smaller range than Y.
set.seed(2)
nObs <- 100 # Number of observations
x <- stats::filter(rnorm(nObs),c(-0.99),
     method="recursive")
x <- x + (x^2) # Nonlinear component
myLags <- 0:2
X <- eTrim(eLag(x,myLags))
Y <- X[,+1,drop=FALSE]
X <- X[,-1,drop=FALSE]
lmObj <- lm(Y ~ X)
Yhat <- predict(lmObj)
Ydiagnostics(Y,Yhat)
}
\seealso{
\code{\link[stats]{cor}}
}

