% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/no_test.R
\name{no_test}
\alias{no_test}
\title{no test will be conducted, but rasch models (RM, PCM, RSM - depending
 on modelType) will be fit}
\usage{
no_test(
  items = NULL,
  dset = NULL,
  na.rm = TRUE,
  model = NULL,
  p.par = NULL,
  modelType = NULL,
  estimation_param = NULL
)
}
\arguments{
\item{items}{a numeric vector containing the index numbers of the items in
dset that are used to fit the model}

\item{dset}{a data.frame containing the data}

\item{na.rm}{a boolean value. If TRUE, all cases with any NA are removed
(na.omit). If FALSE, only cases with full NA responses are removed}

\item{model}{on object of a fit Rasch model, estimated with the packages
'eRm' (classes 'RM', 'PCM' or 'RSM'), 'psychotools' (classes raschmodel,
'pcmodel' or 'rsmodel') or 'pairwise' (class 'pers'), matching the value of
 modelType. If 'model' is provided, this model is used. If NULL, a model is
 fit using 'dset' and 'items'.}

\item{p.par}{a person parameter object matching the class of 'model'. If
NULL, the person parameters will be estimated.}

\item{modelType}{a character value defining the rasch model to fit.
Possible values: "RM", "PCM", "RSM".}

\item{estimation_param}{options for parameter estimation using
\link{estimation_control}}
}
\value{
if there are no items with disordered thresholds in the model, a
 list containing two elements is returned: the pattern that was tested and
  a list of type RM, RCM or RSM (depending on modelType) with the fit
   model. If there is at least one item with disordered thresholds,
    NULL is returned.
}
\description{
no test will be conducted, but rasch models (RM, PCM, RSM - depending
 on modelType) will be fit
}
\keyword{internal}
