% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LTRE_fns.R
\name{exactLTRE}
\alias{exactLTRE}
\title{Exact LTRE analysis}
\usage{
exactLTRE(Aobj, method = "random", maxint = "all", fixed.directional = FALSE)
}
\arguments{
\item{Aobj}{An object containing all the population projection matrices to be
included in the analysis. It should either be a list, or a matrix where each
row is the column-wise vectorization of a matrix.

For one-way fixed design, exactly 2 matrices must be provided. For a
"directional" analyses, one of the provided matrices will serve as the
baseline state (for example, a control or standard-of-reference). In this
case, the matrices need to be ordered as \verb{[baseline matrix, observed matrix}].
For random design, any set of 2 or more matrices can be provided.
The set of matrices passed in must all have the same dimensions.}

\item{method}{Either "random" or "fixed." The default behavior is "random."
See details for more information.}

\item{maxint}{The maximum interaction order to be evaluated. The default input
is "all" but this input can take any integer value. If maxint=3, then the
output will include contributions terms up to 3-way interactions.}

\item{fixed.directional}{A true/false switch that allows the user to specify
whether a directional LTRE should be used. The default behavior is to calculate
a symmetric LTRE, where the mean matrix is used as the baseline matrix. See
details for more guidance.}
}
\value{
This returns a list object, with 3 items: (1) a vector of the matrix
indices where the parameters vary between/among the matrices in Aobj; (2) a
list of the indices varying for each of the contribution terms provided; (3)
a vector of the contribution terms.If the method is "fixed" then these are
contributions to the difference in lambda. If the method is "random" then
these are the contributions to the variance in lambda.

\code{indices.varying} is a vector with the indices of parameters that vary. The
numeric indices count down the columns of a given population projection
matrix. For example, in a 3x3 matrix, the (2,2) position would be identified
with a 5.

\code{varying.indices.list} is a list object, where each entry is a vector
containing the indices (matching the \code{indices.varying} part of the output)
that differed or varied for the corresponding entry in the \code{epsilon} vector.

\code{epsilon} is a vector of contributions to the variance or difference in
lambda due to the observed values of the various life history parameters.
For example, the contribution of adult survival to the Var(lambda) is
determined by setting all parameters \emph{except} adult survival to their mean
values, and then calculating the variance of lambda across this manipulated
set of matrices.
}
\description{
Life Table Response Experiments (LTREs) are a method of comparative demographic
analysis. The purpose is to quantify how the difference or variance in vital
rates (stage-specific survival, growth, and fertility) among populations
contributes to difference or variance in the population growth rate, "lambda."
The exact method of LTRE is based on the principles of functional ANOVA.
The equations and descriptions for the exact method will be published in a
forthcoming paper, which we will link to.
}
\details{
Lambda is the asymptotic population growth rate, defined as the
largest eigenvalue of the population projection matrix.

In a one-way fixed design LTRE, the particular treatment levels or
conditions faced by a population are of interest, so one-way fixed design
LTRE decomposes the difference in lambda due to differences at each position
of the matrices. For a fixed design LTRE, exactly 2 matrices must be
provided.

A random design LTRE treats the different matrices being compared as random
samples from a set of population conditions, without specific focus on the
treatments or conditions that each population experienced. This analysis
decomposes the variance in lambda due to variance and covariance in the
entries at each position in the matrices. For a random design LTRE, at least
2 matrices must be provided.

\code{fixed.directional=FALSE} is most appropriate for comparisons where
none of the matrices are appropriate for use as a baseline or
standard-of-reference. For example, if we want to ask which vital rates
drive the difference in population growth rate for two populations of fish
in separate but similar lakes, we want to use a \emph{symmetric} analysis. In
this case, the difference in lambda is decomposed using the mean matrix as
the baseline. The decomposition is symmetric, meaning that if the treatment
and reference matrix are swapped, the contributions from the vital rates
will be equal in magnitude, but positive contributions will become negative
and vice versa. In this case, it does not matter which order you provide the
matrices in \code{Aobj}, but interpretation will require that you pay
attention to the fact that the sum of contributions will be equal to the
observed difference in lambda between the two matrices in \code{Aobj},
evaluated as lambda(A1) - lambda(A2).

\code{fixed.directional=TRUE} is most appropriate for comparisons between a
control and treatment population in a controlled experiment, or for other
cases where one of the populations can serve as a standard of reference (for
example, the lowest elevation population, or one near the range center). In
this case, the first matrix in \code{Aobj} is used as the baseline. This is
a directional analysis, meaning that if the order in which the two matrices
are provided were to be swapped (switching the baseline matrix and other
observed matrix), the contributions of the vital rates would change. If you
choose a directional analysis, be sure to provide the matrices in
\code{Aobj} ordered as \verb{[baseline matrix, observed matrix}].

We set \code{fixed.directional=FALSE} as the default behavior because most
population projection models are built with field-collected data rather than
controlled experiment data.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
cont_diff<- exactLTRE(list(A1,A2), method='fixed') # contributions to the difference in lambda
cont_var<- exactLTRE(list(A1,A2,A3), method='random') # contributions to the variance of lambda
}
