% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gevcTrain.R
\name{gevcTrain}
\alias{gevcTrain}
\title{GEV Classifier - training}
\usage{
gevcTrain(train)
}
\arguments{
\item{train}{a data matrix containing the train data. Class labels should not be included.}
}
\value{
A numeric vector of two elements containing the estimated parameters of the fitted reversed Weibull.
}
\description{
This function is used to train a GEV classifier. It can be used to perform open set classification based on the generalized extreme value distribution.
}
\details{
For details on the method and parameters see Vignotto and Engelke (2018).
}
\note{
Data are not scaled internally; any preprocessing has to be done externally.
}
\examples{
trainset <- LETTER[1:15000,]
knowns <- trainset[trainset$class==1, -1]
gevClassifier <- gevcTrain(train = knowns)
}
\references{
Vignotto, E., & Engelke, S. (2018). Extreme Value Theory for Open Set Classification - GPD and GEV Classifiers. \emph{arXiv preprint arXiv:1808.09902}.
}
\seealso{
\code{\link{gevcTest}}
}
\author{
Edoardo Vignotto \cr
\email{edoardo.vignotto@unige.ch}
}
