% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRawFossilOccs.R
\name{plotRawFossilOccs}
\alias{plotRawFossilOccs}
\title{Plot a literal interpretation of a fossil record}
\usage{
plotRawFossilOccs(
  data,
  tax.lvl = NULL,
  sort = TRUE,
  use.midpoint = TRUE,
  return.ranges = FALSE,
  knitr = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame} containing fossil data on the age (early and
late bounds of rock layer, respectively labeled as \code{max_ma} and
\code{min_ma}) and the taxonomic level asked in \code{tax_lv}.}

\item{tax.lvl}{A \code{character} giving the taxonomic in which
calculations will be based on, which must refer to the column names in
\code{data}. If \code{NULL} (default value), the function plots every
individual occurrences in \code{data}.}

\item{sort}{\code{logical} indicating if taxa should be sorted by their
\code{max_ma} values (default value is \code{TRUE}). Otherwise (i.e., if
\code{FALSE}), function will follow the order of taxa (or occurrences)
inputted in \code{data}.}

\item{use.midpoint}{\code{logical} indicating if function should use
occurrence midpoints (between \code{max_ma} and \code{min_ma}) as
occurrence temporal boundaries, a method commonly employed in paleobiology
to remove noise related to extremely coarse temporal resolution due to
stratification. This argument is only used if a \code{tax.lvl} is provided.}

\item{return.ranges}{\code{logical} indicating if ranges calculated by
function should be return as a \code{data.frame}. If \code{tax.lvl} is
\code{NULL}, the function don't calculate ranges and so it has nothing
to return.}

\item{knitr}{Logical indicating if plot is intended to show up in RMarkdown files made by the \code{Knitr} R package.}
}
\value{
Plots a pile of the max-min temporal ranges of the chosen
\code{tax.lvl}. This usually will be stratigraphic ranges for occurrences
(so there is no attempt to estimate "true" ranges), and if
\code{tax.lvl = NULL} (the default), occurrences are drawn as ranges of
stratigraphic resolution (= the fossil dating imprecision). If
\code{return.ranges = TRUE}, it returns a \code{data.frame} containing the
diversity (column \code{div}) of the chosen taxonomic level, through time.
}
\description{
\code{plotRawFossilOccs} calculates and plots the early and late boundaries
associated with each taxa in a dataset.
}
\examples{

data("dinos_fossil")
oldpar <- par(no.readonly = TRUE) 
par(mfrow=c(1,2))
plotRawFossilOccs(dinos_fossil, tax.lvl = "species", knitr = TRUE)
plotRawFossilOccs(dinos_fossil, tax.lvl = "genus", knitr = TRUE)
par(oldpar)

}
\author{
Matheus Januario, Jennifer Auler
}
