% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt.single.R.zero.corr.R
\name{opt.single.R.zero.corr}
\alias{opt.single.R.zero.corr}
\title{Fit multivariate Unbiased Random Walk model with uncorrelated trait changes.}
\usage{
opt.single.R.zero.corr(
  yy,
  method = "L-BFGS-B",
  hess = FALSE,
  pool = TRUE,
  trace = FALSE,
  iterations = NULL,
  iter.sd = NULL
)
}
\arguments{
\item{yy}{a multivariate evoTS object.}

\item{method}{optimization method, passed to function optim. Default is "L-BFGS-B".}

\item{hess}{logical, indicating whether to calculate standard errors from the Hessian matrix.}

\item{pool}{indicating whether to pool variances across samples}

\item{trace}{logical, indicating whether information on the progress of the optimization is printed.}

\item{iterations}{the number of times the optimization method is run from different starting points. Default is NULL, meaning the optimization is run once.}

\item{iter.sd}{defines the standard deviation of the Gaussian distribution from which starting values for the optimization routine is run. Default is 1.}
}
\value{
First part of the output reports the log-likelihood of the model and its AICc score. The second part of the output is the maximum log-likelihood model parameters (ancestral.values, R). The last part of the output gives information about the number of parameters in the model (K), number of samples in the data (n) and number of times the optimization routine was run (iter).
}
\description{
Function to find maximum likelihood solution to a multivariate Unbiased Random Walk model with uncorrelated trait changes.
}
\details{
The function searches - using an optimization routine - for the maximum-likelihood solution for a multivariate Unbiased Random Walk model with uncorrelated trait changes.

The argument 'method' is passed to the 'optim' function and is included for the convenience of users to better control the optimization routine. The the default method (L-BFGS-B) seems to work for most evolutionary sequences.

Initial estimates to start the optimization come from maximum-likelihood estimates of the univariate Unbiased Random Walk model (from the paleoTS package) fitted to each time-series separately.

It is good practice to repeat any numerical optimization procedure from different starting points. This is especially important for complex models as the log-likelihood surface might contain more than one peak. The number of iterations is controlled by the argument 'iterations'. The function will report the model parameters from the iteration with the highest log-likelihood.
}
\note{
The models have been implemented to be compatible with the joint parameterization routine in the package paleoTS. The optimization is therefore fit using the actual sample values, with the autocorrelation among samples accounted for in the log-likelihood function. The joint distribution of sample means is multivariate normal, with means and variance-covariances determined by evolutionary parameters and sampling errors.
}
\examples{
## Generate an evoTS object by simulating a multivariate dataset
x <- sim.multi.URW(30)

## Fit a multivariate Unbiased Random Walk model with uncorrelated trait changes.
opt.single.R.zero.corr(x)
}
\references{
Revell, L. J. & Harmon, L. Testing quantitative genetic hypotheses about the evolutionary rate matrix for continuous characters. \emph{Evolutionary Ecology Research} 10, 311–331 (2008).
}
\author{
Kjetil Lysne Voje
}
