% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_event_detection.R
\name{tune_cpdbee_2D}
\alias{tune_cpdbee_2D}
\title{Tunes 2D event detection using labeled data}
\usage{
tune_cpdbee_2D(
  x,
  cl,
  alpha_min = 0.95,
  alpha_max = 0.98,
  alpha_step = 0.01,
  epsilon_min = 2,
  epsilon_max = 12,
  epsilon_step = 2,
  minPts_min = 4,
  minPts_max = 12,
  minPts_step = 2
)
}
\arguments{
\item{x}{The data in an mxn matrix or dataframe.}

\item{cl}{The actual locations of the events.}

\item{alpha_min}{The minimum threshold value.}

\item{alpha_max}{The maximum threshold value.}

\item{alpha_step}{The incremental step size for alpha.}

\item{epsilon_min}{The minimum epsilon value for DBSCAN clustering.}

\item{epsilon_max}{The maximum epsilon value for DBSCAN clustering.}

\item{epsilon_step}{The incremental step size for epsilon for DBSCAN clustering.}

\item{minPts_min}{The minimum minPts value for for DBSCAN clustering.}

\item{minPts_max}{The maximum minPts value for for DBSCAN clustering.}

\item{minPts_step}{The incremental step size for minPts for DBSCAN clustering.}
}
\value{
A list with following components
\item{\code{best}}{The best threshold, epsilon and MinPts for 2D event detection and the associated Jaccard Index.}
\item{\code{all}}{All parameter values used and the associated Jaccard Index values.}
}
\description{
This function finds best parameters for 2D event detection using labeled data.
}
\examples{
\dontrun{
out <- gen_stream(1, sd=15)
zz <- as.matrix(out$data)
clst <- get_clusters(zz, filename = NULL, thres = 0.95, 
                    vis = TRUE, epsilon = 5, miniPts = 10, 
                    rolling = FALSE)
clst_loc <- clst$data[ ,1:2]
out <- tune_cpdbee_2D(zz, clst_loc)
out$best
}
}
