% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBFfit.R
\name{RBFfit}
\alias{RBFfit}
\title{Training of a radial basis function classifier}
\usage{
RBFfit(
  x,
  y,
  param,
  lambda = 0,
  control = list(fnscale = -1, trace = 2, maxit = 1000),
  optimProto = TRUE
)
}
\arguments{
\item{x}{Input matrix of size n x d, where n is the number of objects and d the number of
attributes.}

\item{y}{Vector of class labels (of length n). May be a factor, or a vector of
integers from 1 to M (number of classes).}

\item{param}{Initial parameters (see \code{\link{RBFinit}}).}

\item{lambda}{Regularization hyperparameter (default=0).}

\item{control}{Parameters passed to function \code{\link{optim}}.}

\item{optimProto}{Boolean. If TRUE, the prototypes are optimized (default). Otherwise,
they are fixed.}
}
\value{
A list with three elements:
  \describe{
  \item{param}{Optimized network parameters.}
  \item{loglik}{Final value of the log-likelihood objective function.}
  \item{err}{Training error rate.}
 }
}
\description{
\code{RBFfit} performs parameter optimization for a radial basis function (RBF) classifier.
}
\details{
The RBF neural network is trained by maximizing the conditional log-likelihood (or, equivalently,
by minimizing the cross-entropy loss function). The optimization procedure is the BFGS
algorithm implemented in function \code{optim}.
}
\examples{
## Glass dataset
data(glass)
xapp<-glass$x[1:89,]
yapp<-glass$y[1:89]
## Initialization
param0<-RBFinit(xapp,yapp,nproto=7)
## Training
fit<-RBFfit(xapp,yapp,param0,control=list(fnscale=-1,trace=2))
}
\seealso{
\code{\link{proDSinit}}, \code{\link{proDSval}}
}
\author{
Thierry Denoeux.
}
