% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_gldas_vic.R
\name{download_gldas_vic}
\alias{download_gldas_vic}
\title{GLDAS_VIC data downloader}
\usage{
download_gldas_vic(
  path = "",
  domain = "raw",
  time_res = "monthly",
  variable = "e",
  version = ""
)
}
\arguments{
\item{path}{a character string with the path where the data will be downloaded.}

\item{domain}{a character string with the desired domain data set. Suitable options are:
\itemize{
\item{"raw" for default available spatial coverage,}
\item{"global" for data sets with global (land and ocean) coverage,}
\item{"land" for data sets with land only coverage,}
\item{"ocean", for data sets with ocean only coverage.}
}}

\item{time_res}{a character string with the desired time resolution. Suitable options are:
\itemize{
\item{"monthly",}
\item{"yearly",}
\item{"daily"}
}}

\item{variable}{a character string for the variable. Suitable options are:
\itemize{
\item{"e" for actual evapotranspiration,}
\item{"pet" for potential evapotranspiration.}
}}

\item{version}{an optional character string for the version. Suitable options are:
\itemize{
\item{"v2-0" for version 2.0,}
\item{"v2-1" for version 2.1,}
\item{"" for default version v2-0.}
}}
}
\value{
No return value, called to download the data set.
}
\description{
Downloading GLDAS VIC evapotranspiration data
}
\keyword{internal}
