% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-game-metadata.R
\name{getGameHeader}
\alias{getGameHeader}
\alias{getGamePlayers}
\alias{getGameRound}
\title{Game metadata}
\usage{
getGameHeader(season_code, game_code)

getGamePlayers(season_code, game_code, team_code)

getGameRound(season_code, game_code)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{game_code}{One or more game codes as obtained from \code{\link[=getCompetitionGames]{getCompetitionGames()}}.}

\item{team_code}{One or more team codes as obtained from \code{\link[=getCompetitionTeams]{getCompetitionTeams()}}.\cr
Examples are \code{ASV}, \code{MAD}, ...}
}
\value{
For each function, returns a tibble with information about header,
player or round of chosen season and game code.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Retrieve contextual information about games.
Outputs may be required as arguments of other \verb{getGame*} functions
}
\examples{

\dontrun{

getGameHeader(season_code = c("E2023", "U2023"), game_code = 1)

getGamePlayers(season_code = c("E2023", "U2023"), team_code = "ASV", game_code = 1)

getGameRound(season_code = c("E2023", "U2023"), game_code = 1)

}
}
\keyword{gameMetadata}
