% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data_file.R
\name{import_data_file}
\alias{import_data_file}
\title{Import data from csv file in Shiny App}
\usage{
import_data_file(
  pattern,
  names_files,
  paths_files,
  def_columns,
  transpose = FALSE
)
}
\arguments{
\item{pattern}{Character string containing a regular expression to identify
the correct file by its name.}

\item{names_files}{Character vector of file names as they were uploaded (=
file name on the original file system from which they were uploaded)}

\item{paths_files}{Character vector of file names + absolute paths of the
files in the local hard drive to which they were uploaded. Each entry of
\code{paths_files} corresponds to an entry of \code{names_files}. They must
have the same length.}

\item{def_columns}{Data frame of meta information containing the possible
column names in the different versions of the EuFMDiS output files. The data
frame must contain columns \code{Datensatz} (name of the relevant data frame;
this corresponds to values used in \code{pattern}), \code{Name_Parameter}
(the unified column name in the generated return value) and columns
containing possible variations of the name in the different versions of
EuFMDiS. Each column contains the notation in one version of EuFMDiS; the
column names must begin with the string \code{Spalte}}

\item{transpose}{Logical flag (default = FALSE). COntrols whether the data
frame should be transposed prior to any data manipulation/extraction.}
}
\value{
Data frame containing the columns defined in \code{def_columns} for
the relevant \code{Datensatz} according to the argument \code{pattern}.
}
\description{
The function is used in the ADAPT app to import data from uploaded csv files
into a data frame. Only relevant columns are returned, the column names are
matched and unified, so that data produced by different versions of the
EuFMDiS software can be used.
}
