% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trading.R
\name{etrd_cancel_order}
\alias{etrd_cancel_order}
\title{Cancel an existing order}
\usage{
etrd_cancel_order(
  account,
  orderId,
  output = c("df", "list"),
  access_tokens = NULL,
  etrade_cred = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{account}{The account ID key, not the account ID associated with the
specific account. Use \code{\link{etrd_account_list}} to identify the
proper account id key.}

\item{orderId}{Order confirmation Id for the order placed.}

\item{output}{Indicate whether the output should be in the form of a data
frame ('df') or list ('list'). Data frame is returned by default.}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
a response validating that the order has been canceled
}
\description{
Cancel an open order that has been submitted. Note: Verify the cancel request
was received and processed
}
\examples{
\dontrun{
# Place Mutual Fund Buy order for $10
acts = etrd_account_list()
account = acts$accountIdKey[1]
mforder = etrd_place_mf_order(account = account,
                    symbol = 'SWTSX',
                    quantityType = 'DOLLAR',
                    investmentAmount = 10,
                    mfTransaction = 'buy',
                    reInvestOption = 'reinvest',
                    previewOrder = 'df')

etrd_cancel_order(mforder$accountidKey, mforder$orderid.orderId)

}
}
