% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{etrd_auth_manage_token}
\alias{etrd_auth_manage_token}
\title{Auth - Renew or Revoke Access Tokens as needed}
\usage{
etrd_auth_manage_token(
  action = c("renew", "revoke"),
  access_tokens = NULL,
  etrade_cred = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{action}{Enter 'renew' to activate an inactive access token. Enter
'revoke' to invalidate a current access token.}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
a key and secret oauth access token
}
\description{
#' During the trading day, if two hours have elapsed between API calls, the
token is inactivated. Use this function to refresh an inactivated access
token. This function can also be used to revoke an active access token. Once
a token has been revoked, Auth steps 1-3 will need to be run to get new
access tokens.
}
\details{
The access tokens expire each day at midnight Eastern Time. The
next day, Auth Step 1-3 will need to be run again. This function cannot renew
an expired access token.
}
\examples{
\dontrun{

# Will renew production tokens
etrd_auth_manage_token('renew')

# Will revoke a sandbox access token
etrd_auth_manage_token('revoke', sandbox = TRUE)

}
}
\seealso{
\code{\link{etrd_auth_credentials}} to set the key and secret into
  an oauth app, \code{\link{etrd_auth_login_url}} to generate request tokens
  and create a login URL, \code{\link{etrd_auth_access_token}} to use the
  verification code to create access tokens,
  \code{\link{etrd_auth_manage_token}} to renew or revoke access tokens
}
